<?php 
/**
 * Report page.
 *
 * @todo: Add report description in PHPDoc block.
 * @todo: Cleanup variable block at the top of the file.
 */

global $linkpatrol_link_reports, $linkpatrol_pagination;

$user_id = get_current_user_id();  // set user

if ( ! empty( $_POST['rowsnum'] ) ) {
	// @todo: what if this value hasn't changed? No need to update meta.
	update_user_meta( $user_id, 'linkpatrol_rowsnum', wp_kses( $_POST['rowsnum'], array() ) );
}
if ( ! empty($_POST['date_range'] ) ) {
	// @todo: what if this value hasn't changed? No need to update meta.
	update_user_meta( $user_id, 'linkpatrol_dateint', wp_kses( $_POST['date_range'], array() ) );
}

$linkpatrol_row_number = get_user_meta( $user_id, 'linkpatrol_rowsnum', true );
$linkpatrol_date_int   = get_user_meta( $user_id, 'linkpatrol_dateint', true );

if ( empty( $linkpatrol_row_number ) ) {
	$linkpatrol_row_number = $linkpatrol_pagination->getRowsNum();
}
if ( empty( $linkpatrol_date_int ) ) {
	$linkpatrol_date_int = $linkpatrol_pagination->getDateInterval();
}

if ( ! empty( $_GET['domaintoreport'] ) ) {
	$domain = wp_kses( $_GET['domaintoreport'], array() );
}
if ( ! empty( $_POST['domaintoreport'] ) ) {
	$domain = wp_kses( $_POST['domaintoreport'], array() );
}
if ( ! empty( $_GET['authorid_report'] ) ) {
	$authorID = wp_kses( $_GET['authorid_report'], array() );
}
if ( ! empty( $_POST['authorid_report'] ) ) {
	$authorID = wp_kses( $_POST['authorid_report'], array() );
}

$author_info = get_userdata($authorID);

$PostAuthorDomainReport= $linkpatrol_link_reports->get_domain_author_post_report_data($domain, $authorID);
$order = $linkpatrol_pagination->getOrder();
$wlppage = $linkpatrol_pagination->getPagedNum();
$skey = $linkpatrol_pagination->getSkey();
$linkpatrol_pagination->addClasses( 'linkpatrol_pag' );
$linkpatrol_pagination->setCrumbs( 5 );
$linkpatrol_pagination->setRPP( $linkpatrol_row_number );
$linkpatrol_pagination->setCurrent( $wlppage );

if ( ! empty( $skey ) ) {
	$linkpatrol_pagination->setSkey($skey);
}

$linkpatrol_pagination->setTotal( $PostAuthorDomainReport[1] );


// Start page
if ( isset( $_GET ['_wpnonce_domainauthorpostreport_page'] ) ) {
	$nonce = $_GET['_wpnonce_domainauthorpostreport_page'];
	if ( ! wp_verify_nonce ( $nonce, 'report_page' ) ) {
		wp_die ( __ ( "You didn't pass security check", 'linkpatrol' ) );
	} else { ?>

	<div class="wrap">
		<h2><?php _e( 'LinkPatrol Reports', 'linkpatrol' )?></h2>

		<h2 class="nav-tab-wrapper" >
			<a class="nav-tab " id="general-tab" href="<?php echo admin_url( 'admin.php?page=linkpatrol-overview'  );?>"><?php  _e( 'Overview', 'linkpatrol' )?></a>
			<a class="nav-tab nav-tab-active" id="home-tab" href="<?php echo add_query_arg( array( '_wpnonce_domainreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );?>"><?php  _e( 'Domains', 'linkpatrol' )?> </a>
			<a class="nav-tab" id="post_types-tab" href="<?php echo add_query_arg( array( '_wpnonce_authorreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );?>"><?php  _e( 'Authors', 'linkpatrol' )?> </a>
			<a class="nav-tab" id="taxonomies-tab" href="<?php echo add_query_arg( array( '_wpnonce_keywordsreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );?>"><?php  _e( 'Keywords', 'linkpatrol' )?></a>
		</h2>

		<div class="tabwrapper">
			<p id="report-desc">
				<?php echo sprintf ( __ ( 'Displaying %1$d  links to  %2$s added by %3$s.', 'linkpatrol' ), $PostAuthorDomainReport[1], $domain, $author_info->display_name ); ?>
			</p>

			<form id="edit-form-domain" method="post" action="<?php echo add_query_arg( array( '_wpnonce_domainauthorpostreport_page' => wp_create_nonce( 'report_page' ), 'domaintoreport' => $domain, 'authorid_report' => $authorID), admin_url( 'admin.php?page=linkpatrol-overview'  ) ); ?>">
				<p> 
					<label for="skey">
						Filter by domain name<br />
						<input type="text" name="skey" id="skey" class="regular-text" value="<?php echo $skey; ?>" />
					</label>
				</p>

				<p>
					<label for="lp-date-range">
						<?php _e( 'Date range', 'linkpatrol') ?><br />
						<select id="lp-date-range" name="date_range">
							<option value="99999999" <?php selected( $linkpatrol_date_int, 99999999 ); ?>>
								<?php _e('All', 'linkpatrol') ?>
							</option>
							<option value="1" <?php selected( $linkpatrol_date_int, 1 ); ?>>
								<?php _e('Last day', 'linkpatrol') ?>
							</option>
							<option value="7" <?php selected( $linkpatrol_date_int, 7 ); ?>>
								<?php echo sprintf ( __( 'Last %1$s days', 'linkpatrol' ), 7);?>
							</option>
							<option value="30" <?php selected( $linkpatrol_date_int, 30 ); ?>>
								<?php echo sprintf ( __( 'Last %1$s days', 'linkpatrol' ), 30);?>
							</option>
							<option value="180" <?php selected( $linkpatrol_date_int, 180 ); ?>>
								<?php echo sprintf ( __( 'Last %1$s months', 'linkpatrol' ), 6);?>
							</option>
						</select>
					</label>
				</p>

				<p> 
					<label for="rowsnum">
						<?php _e( 'Rows', 'linkpatrol') ?><br />
						<input type="text" name="rowsnum" id="rowsnum" maxlength="3" size="3" value="<?php echo $linkpatrol_row_number;?>" />
					</label>
				</p>

				<p>
					<input type="submit" class="button-primary"	value="<?php _e( 'Reload Table', 'linkpatrol' ); ?>" />
				</p>
			</form>

			<table class="wp-list-table widefat fixed">
				<thead>
					<tr>
						<th scope="col"><?php _e( 'Post Title', 'linkpatrol' ); ?></th>	
						<th scope="col"><?php _e( 'Link', 'linkpatrol' ); ?></th>
						<th scope="col"><?php _e( 'Text', 'linkpatrol' ); ?></th>
						<th scope="col" class="manage-column sortable <?php echo $order;?>">
							<a href="<?php echo add_query_arg( array(
								'_wpnonce_domainauthorpostreport_page' => wp_create_nonce( 'report_page' ),
								'orderby' => 'post_date',
								'order' => $order,
								'wlppage' => $wlppage,
								'skey' => $skey,
								'domaintoreport' => $domain
								), admin_url( 'admin.php?page=linkpatrol-overview' ) ); ?>">
								<span><?php  _e( 'Publish Date', 'linkpatrol' ); ?></span>
								<span class="sorting-indicator"></span>
							</a>
						</th>				
						<th scope="col"><?php _e( 'Author', 'linkpatrol' ); ?></th>
						<th scope="col"><?php _e( 'Nofollow', 'linkpatrol' ); ?></th>
						<th scope="col"><?php _e( 'Stripped', 'linkpatrol' ); ?></th>
					</tr>
				</thead>

				<tfoot> 
					<tr>
						<th scope="col"><?php _e( 'Post Title', 'linkpatrol' ); ?></th>
						<th scope="col"><?php _e( 'Link', 'linkpatrol' ); ?></th>		
						<th scope="col"><?php _e( 'Text', 'linkpatrol' ); ?></th>	
						<th scope="col"><?php _e( 'Edit Date', 'linkpatrol' ); ?></th>	
						<th scope="col"><?php _e( 'Author', 'linkpatrol' ); ?></th>	
						<th scope="col"><?php _e( 'Nofollow', 'linkpatrol' ); ?></th>	
						<th scope="col"><?php _e( 'Stripped', 'linkpatrol' ); ?></th>		
					</tr>
				</tfoot>

				<tbody id="the-list">
				<?php $i = 0; foreach ( $PostAuthorDomainReport[0] as $value ) {
					$checkbox_class_pref = preg_replace('/[^A-Za-z0-9]/', '', $value['col3'] );	?>
					<tr <?php if($i%2!=0) echo 'class="alternate"'; ?>>
						<td>
							<?php 			
							$post = get_post( $value['col1'], ARRAY_A  );
							$link = get_permalink( $value['col1'] );
							$editLink = get_edit_post_link($value['col1']);
							?>
							<span><?php echo $post["post_title"]?></span>
							<div class="row-actions">
								<span class="edit edit_domain">
									<a title="<?php _e( 'Edit this item', 'linkpatrol' ); ?>" href="<?php echo $editLink; ?>" >
									<?php _e( 'Edit', 'linkpatrol' )?></a> | 
								</span>
								<span class="view">
									<a title="<?php _e( "View this item ", 'linkpatrol' )?>" href="<?php echo $link;  ?>" >
									<?php  echo _e( "View", 'linkpatrol' )?></a>
								</span>
							</div>
						</td>
						<td class="domain">
							<span class="domain-txt"><a href="<?php echo $value['col3']?>"><?php echo $value['col3']; ?></a></span>							
						</td>
						<td><?php echo $value["col2"]?></td>	
						<td><?php echo $value["col4"];?></td>	
						<td>
							<?php $user_info = get_userdata($value['col5']); ?>
							<a href="<?php echo add_query_arg( array(
								'_wpnonce_domainauthorpostreport_page' => wp_create_nonce( 'report_page' ),
								'authorid_report' => $value['col5'],
								'domaintoreport' => $domain,
								'authorname_report' => $user_info->display_name
								), admin_url( 'admin.php?page=linkpatrol-overview' ) ); ?>">
								<?php echo $user_info->display_name;?>
							</a>
						</td>							
						<?php if ( $value['col6'] == 0 ) { ?>
							<td id="chkstrip" class="chkbox<?php echo $i; ?>">	
								<input checked="true" class="chkbox<?php echo $i; ?>" type="checkbox" name="url_linkpatrol_nfoll_edit" data-id="linkpatrol_nofoll_edit-<?php echo $checkbox_class_pref; ?>" value="0" />
							</td>
							<td class="chkbox<?php echo $i; ?>">
								<input type="checkbox" class="chkbox<?php echo $i; ?>" name="url_linkpatrol_nfoll_edit"  data-id="linkpatrol_strip_edit-<?php echo $checkbox_class_pref;?>" value="1" />
							</td>
						<?php } elseif ( $value['col6'] == 1 ) { ?>
							<td id="chkstrip" class="chkbox<?php echo $i; ?>">	
								<input class="chkbox<?php echo $i; ?>" type="checkbox" name="url_linkpatrol_nfoll_edit"  data-id="linkpatrol_nofoll_edit-<?php echo $checkbox_class_pref; ?>" value="0" />
							</td>
							<td class="chkbox<?php echo $i; ?>">
								<input checked="true" class="chkbox<?php echo $i; ?>" type="checkbox" name="url_linkpatrol_nfoll_edit" data-id="linkpatrol_strip_edit-<?php echo $checkbox_class_pref; ?>" value="1" />
							</td>
						<?php } else { ?>
							<td id="chkstrip" class="chkbox<?php echo $i; ?>">	
								<input  class="chkbox<?php echo $i; ?>" type="checkbox" name="url_linkpatrol_nfoll_edit" data-id="linkpatrol_nofoll_edit-<?php echo $checkbox_class_pref; ?>" value="0" />
							</td>
							<td class="chkbox<?php echo $i;?>">
								<input class="chkbox<?php echo $i; ?>" type="checkbox" name="url_linkpatrol_nfoll_edit"  data-id="linkpatrol_strip_edit-<?php echo $checkbox_class_pref;?>" value="1" />

							</td>
						<?php } ?>
					</tr>
					<?php $i++; }?>
				</tbody>
			</table>
				
			<div class="lp-clear">
				<div class="left-half">
					<?php
					$markup = $linkpatrol_pagination->parse();
					echo $markup;
					?>
				</div>

				<div class="right-half">
					<input type="button" id="update-urls" class="button-primary" value="<?php _e( 'Update', 'linkpatrol' ); ?>" />
					<div class="loader"> 
						<img src="<?php echo LINKPATROL_PLUGIN_URL . '/images/loading.gif'; ?>" />
					</div>
				</div>
			</div>

			<form method="post" action="" enctype="multipart/form-data">
				<?php wp_nonce_field( 'linkpatrol_csv', '_wpnonce_linkpatrol_csv' ); ?>
				<?php wp_nonce_field( 'linkpatrol_domain_author_post_report_csv', '_wpnonce_linkpatrol_domain_author_post_report_csv' ); ?>
				<input type="hidden" name="report_csv_domain" value="<?php echo $domain; ?>" />
				<input type="hidden" name="report_csv_author_id" value="<?php echo $authorID; ?>" />
				<input type="hidden" name="report_csv_author_name" value="<?php echo $author_info->display_name; ?>" />
				<input type="hidden" name="_wp_http_referer" value="<?php echo wp_kses( $_SERVER['REQUEST_URI'], array() ); ?>" />
				<input type="submit" class="button-secondary" value="<?php _e( 'Export Data as CSV', 'linkpatrol' ); ?>" />
			</form>
		</div>
	</div><!-- .wrap -->

	<?php } ?>
<?php } ?>