<?php 
/**
 * Report page.
 *
 * @todo: Add report description in PHPDoc block.
 * @todo: Cleanup variable block at the top of the file.
 */

global $linkpatrol_link_reports, $linkpatrol_pagination;

$user_id = get_current_user_id(); // set user

if ( ! empty( $_POST['rowsnum'] ) ) {
	// @todo: what if this value hasn't changed? No need to update meta.
	update_user_meta( $user_id, 'linkpatrol_rowsnum', wp_kses( $_POST['rowsnum'], array() ) );
}
if ( ! empty($_POST['date_range'] ) ) {
	// @todo: what if this value hasn't changed? No need to update meta.
	update_user_meta( $user_id, 'linkpatrol_dateint', wp_kses( $_POST['date_range'], array() ) );
}

$linkpatrol_row_number = get_user_meta( $user_id, 'linkpatrol_rowsnum', true );
$linkpatrol_date_int   = get_user_meta( $user_id, 'linkpatrol_dateint', true );

if ( empty ( $linkpatrol_row_number ) ) {
	$linkpatrol_row_number = $linkpatrol_pagination->getRowsNum();
}
if( empty( $linkpatrol_date_int ) ) {
	$linkpatrol_date_int = $linkpatrol_pagination->getDateInterval();
}

if( ! empty( $_GET['domaintoreport'] ) ) {
	$domain = wp_kses( $_GET['domaintoreport'], array() );
}
if( ! empty( $_POST['domaintoreport'] ) ) {
	$domain = wp_kses( $_POST['domaintoreport'], array() );
}

$linkpatrol_all_authors_domain_report= $linkpatrol_link_reports->get_all_authors_domain_report_data($domain);

$order   = $linkpatrol_pagination->getOrder();
$wlppage = $linkpatrol_pagination->getPagedNum();
$skey    = $linkpatrol_pagination->getSkey();

$linkpatrol_pagination->addClasses( 'linkpatrol_pag' );
$linkpatrol_pagination->setCrumbs( 5 );
$linkpatrol_pagination->setRPP( $linkpatrol_row_number );
$linkpatrol_pagination->setCurrent($wlppage );

if ( ! empty( $skey ) ) {
	$linkpatrol_pagination->setSkey( $skey );
}

$linkpatrol_pagination->setTotal( $linkpatrol_all_authors_domain_report[1] );


// Start page
if ( isset ( $_GET['_wpnonce_allauthorreport_page'] )) {
	$nonce = $_GET['_wpnonce_allauthorreport_page'];

	if (! wp_verify_nonce ( $nonce, 'report_page' )) {
		wp_die ( __ ( 'You didn\'t pass security check', 'linkpatrol' ) );
	} else { ?>

	<div class="wrap">
		<h2><?php _e( 'LinkPatrol Reports', 'linkpatrol' )?></h2>
				
		<h2 class="nav-tab-wrapper" >
			<a class="nav-tab " id="general-tab" href="<?php echo admin_url( 'admin.php?page=linkpatrol-overview'  );?>"><?php  _e( 'Overview', 'linkpatrol' )?></a>
			<a class="nav-tab nav-tab-active" id="home-tab" href="<?php echo add_query_arg( array( '_wpnonce_domainreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );?>"><?php  _e( 'Domains', 'linkpatrol' )?> </a>
			<a class="nav-tab" id="post_types-tab" href="<?php echo add_query_arg( array( '_wpnonce_authorreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );?>"><?php  _e( 'Authors', 'linkpatrol' )?> </a>
			<a class="nav-tab" id="taxonomies-tab" href="<?php echo add_query_arg( array( '_wpnonce_keywordsreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );?>"><?php  _e( 'Keywords', 'linkpatrol' )?></a>
		</h2>	
			
		<div class="tabwrapper">
			<p id="report-desc">
				<?php echo sprintf( __(
					'Displaying %2$d authors who link to %1$s', 'linkpatrol' ),
					$domain,
					$linkpatrol_all_authors_domain_report[1]
				); ?>
			</p>

			<form id="edit-form-domain" method="post" action="<?php echo add_query_arg( array( '_wpnonce_allauthorreport_page'=> wp_create_nonce( 'report_page' ), 'domaintoreport'=>$domain ), admin_url( 'admin.php?page=linkpatrol-overview'  ) ); ?>">
				<p> 
					<label for="skey">
						Filter by domain name<br />
						<input type="text" name="skey" id="skey" class="regular-text" value="<?php echo $skey; ?>" />
					</label>
				</p>

				<p>
					<label for="lp-date-range">
						<?php _e( 'Date range', 'linkpatrol') ?><br />
						<select id="lp-date-range" name="date_range">
							<option value="99999999" <?php selected( $linkpatrol_date_int, 99999999 ); ?>>
								<?php _e('All', 'linkpatrol') ?>
							</option>
							<option value="1" <?php selected( $linkpatrol_date_int, 1 ); ?>>
								<?php _e('Last day', 'linkpatrol') ?>
							</option>
							<option value="7" <?php selected( $linkpatrol_date_int, 7 ); ?>>
								<?php echo sprintf ( __( 'Last %1$s days', 'linkpatrol' ), 7);?>
							</option>
							<option value="30" <?php selected( $linkpatrol_date_int, 30 ); ?>>
								<?php echo sprintf ( __( 'Last %1$s days', 'linkpatrol' ), 30);?>
							</option>
							<option value="180" <?php selected( $linkpatrol_date_int, 180 ); ?>>
								<?php echo sprintf ( __( 'Last %1$s months', 'linkpatrol' ), 6);?>
							</option>
						</select>
					</label>
				</p>

				<p> 
					<label for="rowsnum">
						<?php _e( 'Rows', 'linkpatrol') ?><br />
						<input type="text" name="rowsnum" id="rowsnum" maxlength="3" size="3" value="<?php echo $linkpatrol_row_number;?>" />
					</label>
				</p>

				<p>
					<input type="submit" class="button-primary"	value="<?php _e( 'Reload Table', 'linkpatrol' ); ?>" />
				</p>
			</form>

			<ul class="table-desc">
				<li>
					<?php _e( '<strong>Posts with links</strong> - Number of posts with links to current domain published by this author', 'linkpatrol' ); ?>
				</li>
				<li>
					<?php _e( '<strong>Links</strong> - Number of links to current domain added by this author', 'linkpatrol' ); ?>
				</li>
			</ul>

			<table class="wp-list-table widefat fixed">
				<thead>
					<tr>
						<th scope="col" class="manage-column sortable <?php echo $order;?>">
							<a href="<?php echo add_query_arg( array(
								'_wpnonce_allauthorreport_page'=> wp_create_nonce( 'report_page' ),
								'orderby' => 'domain',
								'order'=> $order,
								'wlppage' => $wlppage,
								'skey' => $skey,
								'domaintoreport' => $domain
								), admin_url( 'admin.php?page=linkpatrol-overview' ) ); ?>">
								<span><?php _e( 'Author', 'linkpatrol' )?></span>
								<span class="sorting-indicator"></span>
							</a>
						</th>

						<th scope="col" class="manage-column sortable <?php echo $order;?>">
							<a href="<?php echo add_query_arg( array(
								'_wpnonce_allauthorreport_page'=> wp_create_nonce( 'report_page' ),
								'orderby' => 'col2',
								'order' => $order,
								'wlppage' => $wlppage,
								'skey' => $skey,
								'domaintoreport' => $domain
								), admin_url( 'admin.php?page=linkpatrol-overview' ) ); ?>">
								<span><?php _e( 'Posts with links', 'linkpatrol' )?></span>
								<span class="sorting-indicator"></span>
							</a>	
						</th>

						<th scope="col" class="manage-column sortable <?php echo $order;?>">
							<a href="<?php echo add_query_arg( array(
								'_wpnonce_allauthorreport_page' => wp_create_nonce( 'report_page' ),
								'orderby'=> 'col3',
								'order' => $order,
								'wlppage' => $wlppage,
								'skey' => $skey,
								'domaintoreport' => $domain
								), admin_url( 'admin.php?page=linkpatrol-overview'  ) ); ?>">
								<span><?php _e( 'Links', 'linkpatrol' )?></span>
								<span class="sorting-indicator"></span>
							</a>			
						</th>				
					</tr>
				</thead>
				
				<tfoot> 
					<tr>
						<th scope="col" class="manage-column sortable <?php echo $order;?>">
							<a href="<?php echo add_query_arg( array(
								'_wpnonce_allauthorreport_page' => wp_create_nonce( 'report_page' ),
								'orderby' => 'domain',
								'order' => $order,
								'wlppage' => $wlppage,
								'skey' => $skey,
								'domaintoreport' => $domain
								), admin_url( 'admin.php?page=linkpatrol-overview' ) ); ?>">
								<span><?php _e( 'Author', 'linkpatrol' )?></span>
								<span class="sorting-indicator"></span>
							</a>
						</th>

						<th scope="col" class="manage-column sortable <?php echo $order;?>">
							<a href="<?php echo add_query_arg( array(
								'_wpnonce_allauthorreport_page' => wp_create_nonce( 'report_page' ),
								'orderby' => 'col2',
								'order' => $order,
								'wlppage' => $wlppage,
								'skey' => $skey,
								'domaintoreport' => $domain
								), admin_url( 'admin.php?page=linkpatrol-overview'  ) ); ?>">
								<span><?php _e( 'Posts with links', 'linkpatrol' )?></span>
								<span class="sorting-indicator"></span>
							</a>
						</th>

						<th scope="col" class="manage-column sortable <?php echo $order;?>">
							<a href="<?php echo add_query_arg( array(
								'_wpnonce_allauthorreport_page' => wp_create_nonce( 'report_page' ),
								'orderby' => 'col3',
								'order' => $order,
								'wlppage' => $wlppage,
								'skey' => $skey,
								'domaintoreport' => $domain
								), admin_url( 'admin.php?page=linkpatrol-overview' ) ); ?>">
								<span><?php  _e( "Links", 'linkpatrol' )?></span>
								<span class="sorting-indicator"></span>
							</a>
						</th>				
					</tr>
				</tfoot>

				<tbody id="the-list">
				<?php $i=0; foreach ( $linkpatrol_all_authors_domain_report[0] as $value ) { ?>
					<tr <?php if ( $i%2 != 0 ) echo 'class="alternate"';?>>
						<td><?php echo $value['col1']?></td>
						<td><?php echo $value["col2"]?></td>	
						<td>
							<a href="<?php echo add_query_arg( array('_wpnonce_domainauthorpostreport_page'=> wp_create_nonce( 'report_page' ), 'authorid_report'=> $value["col4"], 'domaintoreport'=> $domain), admin_url( 'admin.php?page=linkpatrol-overview'  ) );?>">
								<?php echo $value["col3"]?>
							</a>
						</td>	
					</tr>
				<?php $i++; } ?>
				</tbody>
			</table>
				
			<div class="lp-clear">
				<div class="left-half">
					<?php
					$markup = $linkpatrol_pagination->parse();
					echo $markup;
					?>
				</div>
			</div>
					
			<form method="post" action="" enctype="multipart/form-data">
				<?php wp_nonce_field( 'linkpatrol_csv', '_wpnonce_linkpatrol_csv' ); ?>
				<?php wp_nonce_field( 'linkpatrol_all_author_report_csv', '_wpnonce_linkpatrol_all_author_report_csv' ); ?>
				<input type="hidden" name="report_csv_domain" value="<?php echo $domain;?>" />
				<input type="hidden" name="_wp_http_referer" value="<?php echo esc_attr( $_SERVER['REQUEST_URI'] ); ?>" />
				<input type="submit" class="button-secondary" value="<?php _e( 'Export Data as CSV', 'linkpatrol' ); ?>" />
			</form>
		</div>
	</div><!-- .wrap -->

	<?php } ?>
<?php } ?>