<?php
/**
 * Scanner page.
 */

global $linkpatrol_link_reports;
do_action( 'linkpatrol-report' );

$linkpatrol_check_for_scanned = $linkpatrol_link_reports->check_links_table();
$linkpatrol_domains_overview  = $linkpatrol_link_reports->domain_total_links();
$linkpatrol_authors_overview  = $linkpatrol_link_reports->authors_avg_links();
$linkpatrol_links_overview    = $linkpatrol_link_reports->links_overview();

$linkpatrol_domain_page = add_query_arg( array( '_wpnonce_domainreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );
$linkpatrol_authors_page = add_query_arg( array( '_wpnonce_authorreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );
$linkpatrol_keywords_page = add_query_arg( array( '_wpnonce_keywordsreport_page'=> wp_create_nonce( 'report_page' ) ), admin_url( 'admin.php?page=linkpatrol-overview'  ) );

if ( $linkpatrol_check_for_scanned ) : ?>

	<div class="wrap">
		<h2><?php  _e( 'Overview', 'linkpatrol' )?></h2>

		<div class="metabox-holder linkpatrol-cont"> 
			<div class="meta-box-sortables ui-sortable"> 
				<h2 class="nav-tab-wrapper" >
					<a class="nav-tab nav-tab-active" id="general-tab" href="<?php echo admin_url( 'admin.php?page=linkpatrol-overview'  );?>"><?php  _e( "Overview", 'linkpatrol' )?></a>
					<a class="nav-tab" id="home-tab" href="<?php echo $linkpatrol_domain_page;?>"><?php  _e( "Domains", 'linkpatrol' )?> </a>
					<a class="nav-tab" id="post_types-tab" href="<?php echo $linkpatrol_authors_page;?>"><?php  _e( "Authors", 'linkpatrol' )?> </a>
					<a class="nav-tab" id="taxonomies-tab" href="<?php echo $linkpatrol_keywords_page;?>"><?php  _e( "Keywords", 'linkpatrol' )?></a>
				</h2>

				<div class="tabwrapper overview-tabwrapper">
					<div class="clearfix">
						<div class="col13">
							<div class="report-wrapper">
								<div class="overview-top">
									<h1 class="text-center"><?php echo $linkpatrol_links_overview[0];?></h1>
									<p class="text-center"><?php _e( "Posts scanned", 'linkpatrol' )?></p>
								</div>

								<div class="overview-bottom">
									<div class="left">
										<h2><?php echo $linkpatrol_links_overview[1] ;?></h2>
										<p><?php _e( "Links Found", 'linkpatrol' )?></p>
									</div>

									<div class="right">
										<h2><?php echo number_format($linkpatrol_links_overview[2], 1);?></h2>
										<p><?php _e( "Links per post", 'linkpatrol' )?></p>
									</div>
								</div>
							</div><!-- .report-wrapper -->
						</div>

						<div class="col13">
							<div class="report-wrapper">
								<h2 class="text-center"><?php _e( "Internal vs. external", 'linkpatrol' )?></h2>
								<div id="intern-vs-ext" ></div>
							</div><!-- .report-wrapper -->
						</div>

						<div class="col13">
							<div class="report-wrapper">
								<h2 class="text-center"><?php _e( "External links per post", 'linkpatrol' )?></h2>
								<div id="links-per-post" ></div>
							</div><!-- .report-wrapper -->
						</div>
					</div>

					<div class="clearfix">
						<div class="col1">
							<div class="report-wrapper">
								<h2 class="text-center"><?php _e( "Total links per domain", 'linkpatrol' )?></h2>
								<div id="links-per-domain" style="height:400px; "></div>	
							</div><!-- .report-wrapper -->
						</div>

						<div class="col2">
							<div class="report-wrapper">
								<h2 class="text-center"><?php _e( "Author's links per post", 'linkpatrol' )?></h2>
								<div id="auth-links-per-post" style="height:400px; "></div>
							</div><!-- .report-wrapper -->
						</div>
					</div>
				</div>
			</div>
		</div><!-- .tabwrapper -->
	</div><!-- .wrap -->

<?php else : ?>
		
	<div class="wrap vertically-middle">
		<h2 class="center-text"><?php _e( 'Welcome! Start Your First Scan.', 'linkpatrol' ) ?></h2>
		<p class="center-text"><strong><?php _e('You will be redirected to scanner page', 'linkpatrol' ) ?></strong></p>
		<script type="text/javascript">
		setTimeout( function() {
			window.location = "<?php echo admin_url( 'admin.php?page=linkpatrol_settings_scanner'   )?>";
		}, 1000 );
		</script>
	</div>

<?php endif;?>