<?php
/*
Plugin Name: LinkPatrol
Plugin URI: http://linkpatrolwp.com
Description: LinkPatrol helps you find, review and clean up links in your posts and pages.
Author: Alpha Brand Media
Author URI: http://www.alphabrandmedia.com
Version: 0.1-alpha
Licence: GPL2+
Text Domain: linkpatrol
Domain Path: /languages/
*/

// Define plugin constants.
defined( 'LINKPATROL_PLUGIN_DIR' ) or define( 'LINKPATROL_PLUGIN_DIR', dirname( __FILE__ ) );
defined( 'LINKPATROL_PLUGIN_URL' ) or define( 'LINKPATROL_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
defined( 'LINKPATROL_VER' )        or define( 'LINKPATROL_VER', '0.1-alpha' );

/**
 * Plugin installation function.
 */
register_activation_hook ( __FILE__, 'linkpatrol_install' );
function linkpatrol_install() {
	global $wpdb;
	global $linkpatrol_db_ver;
	$linkpatrol_db_ver = '0.1-alpha';

	$linkpatrol_links_table     = $wpdb->prefix . 'linkpatrol_links';
	$linkpatrol_blacklist_table = $wpdb->prefix . 'linkpatrol_bwlisted';

	$linkpatrol_sql_links = "CREATE TABLE " . $linkpatrol_links_table . " (
		ID bigint(20) unsigned NOT NULL AUTO_INCREMENT,
		anchor_tag text  NOT NULL,
		full_url text  NOT NULL,
		domain text  NOT NULL,
		anchor_text text  NOT NULL,
		post_id bigint(20) unsigned  NOT NULL,
		author_id mediumint(9)  NOT NULL,
		post_date datetime NOT NULL DEFAULT '0000-00-00 00:00:00',	
		link_count int  NOT NULL DEFAULT 1,  	
		fol_strip tinyint(1) NOT NULL DEFAULT 3,
		PRIMARY KEY  ID (ID)
	);";
	
	
	$linkpatrol_sql_domains = "CREATE TABLE " . $linkpatrol_blacklist_table . " (
		ID bigint(20) unsigned NOT NULL AUTO_INCREMENT,
		url varchar(255) NOT NULL,
		domain varchar(255) NOT NULL,
		fol_strip tinyint(1) NOT NULL,
		PRIMARY KEY  ID (ID),
		UNIQUE  KEY domain (domain)
	);";
	
    $linkpatrol_final_sql = $linkpatrol_sql_links . ' ' . $linkpatrol_sql_domains;
	 
	// Create DB tables
	require_once (ABSPATH . 'wp-admin/includes/upgrade.php');
	dbDelta ( $linkpatrol_final_sql );

	// Record database version number
	add_option ( 'linkpatrol_db_ver', $linkpatrol_db_ver );
}

/**
 * Plugin uninstall function.
 */
register_uninstall_hook(    __FILE__, 'linkpatrol_uninstall' );
function linkpatrol_uninstall() {
	global $wpdb;

	// Delete options and database tables
	delete_option( 'linkpatrol_db_ver' );
	$wpdb->query(
		$wpdb->prepare( "DROP TABLE IF EXISTS " . $wpdb->prefix . "linkpatrol_links" )
	);
	$wpdb->query(
		$wpdb->query( "DROP TABLE IF EXISTS " . $wpdb->prefix . "linkpatrol_bwlisted" )
	);
}

/**
 * Load plugin textdomain.
 */
add_action( 'plugins_loaded', 'linkpatrol_textdomain_init' );
function linkpatrol_textdomain_init() {
	load_plugin_textdomain( 'linkpatrol', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
}

// Load includes.
require_once( LINKPATROL_PLUGIN_DIR . '/libs/paginator/class-pagination.php' );
require_once( LINKPATROL_PLUGIN_DIR . '/libs/class-scanner.php' );
require_once( LINKPATROL_PLUGIN_DIR . '/libs/class-reports.php' );
require_once( LINKPATROL_PLUGIN_DIR . '/libs/class-domains.php' );
require_once( LINKPATROL_PLUGIN_DIR . '/libs/class-output-control.php' );

/**
 * Load plugin textdomain.
 *
 * @todo Remove $linkpatrol_test_reports
 */
add_action( 'init', 'linkpatrol_init' );
function linkpatrol_init() {
	if ( is_admin() ) {
		global $linkpatrol_link_scan,
			$linkpatrol_link_reports,
			$linkpatrol_domains,			
			$linkpatrol_pagination;

		$linkpatrol_pagination = new LinkPatrol_Pagination();
		$linkpatrol_link_scan = new LinkPatrol_Scanner();
		$linkpatrol_link_reports = new LinkPatrol_Reports();
		$linkpatrol_domains = new LinkPatrol_Domains();
	} else {
		$output_control = new LinkPatrol_Output_Control();
	}	
}