<?php

/**
 * Pagination
 *
 * Supplies an API for managing domains details in domain-page.php
 *
 */
class LinkPatrol_Domains {
	
	/**
	 * prefix
	 *
	 * Database prefix
	 *
	 * @var string
	 * @access private
	 */
	private $prefix;	

	/**
	 * poststable
	 *
	 * Posts table name
	 *
	 * @var string
	 * @access private
	 */
	private	$poststable;
	
	/**
	 * domainstable
	 *
	 * Domains table name
	 *
	 * @var string
	 * @access private
	 */
	private $domainstable;
	
	/**
	 * linkstable
	 *
	 * Links table name
	 *
	 * @var string
	 * @access private
	 */
	private $linkstable;
	private	$blog_domain;
	private $hooksuff_domain;
	private $capability_domain;
    private $paginationObj ;
    
    	
	function __construct(){
		global $wpdb;		
		$this->prefix = $wpdb->prefix;
		$this->poststable = $this->prefix."posts";		
		$this->domainstable = $this->prefix . "linkpatrol_bwlisted";
		$this->linkstable = $this->prefix . "linkpatrol_links";
		
		// Get blog domain for later use
		$this->blog_domain = parse_url ( get_option ( "siteurl" ), PHP_URL_HOST );
		$this->paginationObj = new LinkPatrol_Pagination();
		add_action( 'admin_enqueue_scripts', array( &$this, 'linkpatrol_domain_enqueues' ) );
		
		// Ajax update action that handles update from reports table
		add_action( 'wp_ajax_linkpatroldomainupdate', array( &$this, 'ajax_domain_update' ) );
		add_action( 'wp_ajax_nopriv_linkpatroldomainupdate', array( &$this, 'ajax_domain_update' ) );		
		add_action('admin_menu', array( &$this, 'linkpatrol_domains_create_menu' ));
		
		// Domains table actions 
		add_action ( "linkpatrol-adddomain",  array( &$this, 'save_domain_handler' ) );
		
		// Set capability of users who can use domains page
		$this->capability_domain = apply_filters( 'linkpatrol', 'edit_pages' );		
	}
		
	function linkpatrol_domain_enqueues( $hook_suffix ) {
		if ($hook_suffix != $this->hooksuff_domain)
			return;		
		wp_enqueue_style( 'linkpatrol-scan-style', LINKPATROL_PLUGIN_URL."css/style.css", array(), LINKPATROL_VER);			
		wp_enqueue_script( 'linkpatrol-domain', LINKPATROL_PLUGIN_URL."js/linkpatrol-domain.js", array('jquery'), LINKPATROL_VER);
	}
	
	function linkpatrol_domains_create_menu() {
		
		// Create sub menu page to linkpatrol top level page
		$this->hooksuff_domain = add_submenu_page( 'linkpatrol', 'Domain Control', 'Domain Control', $this->capability_domain, 'linkpatrol_domains_settings', array( &$this, 'linkpatrol_domains_page' ));	
	}
			
	function linkpatrol_domains_page() {	
		require_once(LINKPATROL_PLUGIN_DIR."/optionspage/domain-page.php");
	}
	
	function save_domain_handler() {
		if (isset ( $_POST ['_wpnonce_add_domain'] ) && !empty ( $_POST ['_wpnonce_add_domain'] )) {
			$nonce = $_POST ['_wpnonce_add_domain'];
			if (! wp_verify_nonce ( $nonce, 'linkpatrol_domain' )) {
	
				wp_die ( __ ( "You didn't pass security check", 'linkpatrol' ) );
					
			} else {
				
				
				if (isset ( $_POST ["linkpatrol_url"] ) &&  !empty($_POST ["linkpatrol_url"])) {
					
					    $resultarray = array();
						$resultarray= array($_POST["linkpatrol_url"], $_POST["linkpatrol_nfoll"]);
					
						$result = $this->add_new_item($resultarray);
						
						if($result[0]){
							echo '<div class="updated">' . __ ( 'Domain was added successfully', 'linkpatrol' ).'<br/>'.$result[0][0]. '</div>';
								
						}
						else {
							if(!empty($result[2]))
								echo '<div class="error">' . __ ( 'Invalid domain name', 'linkpatrol' ).'<br/>'.$result[2][0]. '</div>';
							elseif(!empty($result[1])){
								echo '<div class="error">' . __ ( 'Dublicate Entry', 'linkpatrol' ).'<br/>'.$result[1][0]. '</div>';
					
							}
						}
				}else {
				
						echo '<div class="error">' . __ ( 'Please Fill Domain Field', 'linkpatrol' ) . '</div>';
				}
				
			}
		}
		
		if (isset ( $_GET ['_wpnonce_domain'] ) && !empty ( $_GET ['_wpnonce_domain'] ) ) {
			$nonceget = $_GET ['_wpnonce_domain'];
			if (! wp_verify_nonce ( $nonceget, 'linkpatrol_domain' )) {
		
				wp_die ( __ ( "You didn't pass security check", 'linkpatrol' ) );
					
			} else {
				
				if( isset($_GET["delete_domain"])){
						
					if($this->delete_item($_GET["delete_domain"]))
						echo '<div class="updated">' . sprintf ( __ ( 'Delete is succesful', 'linkpatrol' ) ) . '</div>';
					else
						echo '<div class="error">' . __ ( 'Something went wrong in Deleting', 'linkpatrol' ) . '</div>';
				
				}
				
			}
		}
		
		
		if (isset ( $_POST ['_wpnonce_updatedomain'] ) && !empty ( $_POST ['_wpnonce_updatedomain'] )) {
			$nonceupdate = $_POST ['_wpnonce_updatedomain'];
			if (! wp_verify_nonce ( $nonceupdate, 'linkpatrol_updatedomain' )) {		
				wp_die ( __ ( "You didn't pass security check", 'linkpatrol' ) );					
			} else {		
				$resultarray = array();
				if(!empty($_POST["linkpatrol_nfoll_edit"])){
					foreach ($_POST["linkpatrol_nfoll_edit"] as $key => $value) {
						if(!isset($_POST["domain"]) || empty($_POST["domain"])){
						$domain = '';
						} else { 	
						$domain =$_POST["domain"][$key];
						}
						$resultarray[$key] = array($domain ,$_POST["linkpatrol_nfoll_edit"][$key]);
					}
				}
				
				foreach ($resultarray as $key => $value) {
					//print_r($value);
					$result = $this->update_item($value,$key);
					if(!empty($result[2])){
						echo '<div class="error">' . __ ( 'Invalid domain name', 'linkpatrol' ).'<br/>'.$result[2][0]. '</div>';					
					}
					
					if(!empty($result[1])){
						echo '<div class="updated">' . __ ( 'Domain was updated successfully', 'linkpatrol' ).'<br/>'.$result[1][0]. '</div>';							
					}		
				}
			}
		}
	
		// die;
	}

	function insert_item($data){
		if(!empty($data)){
			$data["domain"] = str_ireplace("www.", "", $data["domain"]);
	  
		global$wpdb;
		$success = $wpdb->insert(
				$this->domainstable,
				array(
						'url' => $data["url"],
						'domain' => $data["domain"],
						'fol_strip'=> $data["fol_strip"]
				),
				array(
						'%s',
						'%s',
						'%d',
						
				)
		);
		
	}
	
	if($success)
	return true;
	else
	return false;
	
	}
	
	function delete_item($ID){
		if(!empty($ID)){
			global$wpdb;
					
			$success = $wpdb->query(
					$wpdb->prepare(
							"
							DELETE FROM $this->domainstable
							WHERE ID = %d						
							",
							$ID
					)
			);
	
		}
		if($success)
			return true;
		else
			return false;
	
	}
	
	function check_exist($domain){
		global$wpdb;
		if(stripos ( $domain, "www." ) === 0){
			$domain = str_ireplace("www.", "", $domain);
		}
		$sqlCount = "SELECT ID FROM {$this->domainstable} where domain=%s";
		$totaldata = $wpdb->get_results($wpdb->prepare($sqlCount, $domain));
	
		return $totaldata;
	}
	
	function check_exist_url($url){
		global$wpdb;
		$sql = "SELECT fol_strip FROM {$this->linkstable} where full_url=%s LIMIT 1";
		$totaldata = $wpdb->get_col($wpdb->prepare($sql, $url));
	  //  echo ($wpdb->prepare($sql, $url))."<br/><br/>";
		return $totaldata[0];
	}
	
	function is_valid_domain_name($domain_name)
	{
		
	    $chkp = preg_match("/^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,6}$/", $domain_name);
		
		return $chkp;
		
		
	}
	
	function add_new_item($array){
		if(!empty($array) ){
			global$wpdb;
			$array[0]=trim($array[0]);
			if(stripos (  $array[0], "//" ) === 0) {
				$array[0] = 'http:' .  $array[0];
			}
			if(filter_var($array[0], FILTER_VALIDATE_URL) !== FALSE)
				$domain = parse_url ( $array[0], PHP_URL_HOST );
			else
				$domain = $array[0];
			
			$domain = preg_replace('#^www\.(.+\.)#i', '$1', $domain);
		 
		   $fol_strip = $array[1];
			
			$totaldata = $this->check_exist($domain); // check if domain exist
			$faileddomains = array();
			$invaliddomains = array();
			$successful = array();
			
			if(!$totaldata){  // check if domain name exist or haven't changed
	
				if($this->is_valid_domain_name($domain)  ){
						$result = $wpdb->insert(
							$this->domainstable,
							array(
									
									'domain' => $domain,
									'fol_strip'=> $fol_strip
							),
							array(
									'%s',									
									'%d',
					
							)
					);
						if($result)
						$successful[] = $domain;
						
					
				}
				else {
					$invaliddomains[]= $domain;
				}
			}
			else {
				
					$faileddomains[] = $domain;
			}
	
		}
		 
		return array($successful, $faileddomains, $invaliddomains);
	
	
	}
	
	function update_item($array, $key){
		if(!empty($array) && !empty($key) ){
			global$wpdb;
			$array[0]=trim($array[0]);
			$array[0] = preg_replace('#^www\.(.+\.)#i', '$1', $array[0]);
		    $totaldata = $this->check_exist($array[0]); // check if domain exist
			$faileddomains = array();
			$invaliddomains = array();
			$successful = array();
			if(!$totaldata &&  !empty($array[0])){  // check if domain name exist or haven't changed
				
				     
			if($this->is_valid_domain_name($array[0])  ){
				
				$result[] = $wpdb->update(
						$this->domainstable,
						array(
								'domain' => $array[0],	// string
								'fol_strip' => $array[1]
						),
						array( 'ID' => $key ),
						array(
								'%s',
								'%d',
								
						),
						array( '%d' )
				);
				$successful[]= $array[0];
			}
			else {
				$invaliddomains[]= $array[0];
			}			
			}
			else {
				
				$result[] = $wpdb->update(
						$this->domainstable,
						array(
								
								'fol_strip' => $array[1],	// string
								
						),
						array( 'ID' => $key ),
						array(
								
								'%d'
								
						),
						array( '%d' )
				);
				
				
			}
	
		}
		     
				return array($result,$successful, $invaliddomains);
				
	
	}
	
	function get_domains_data(){
		global $wpdb;
		
		$rowsperpage = $this->paginationObj->getRowsNum();
		$currentpage = $this->paginationObj->getPagedNum();
		$order =  $this->paginationObj->getOrder();
		
		$orderby =  $this->paginationObj->getOrderBy();
		$keyword = $this->paginationObj->getSkey();
		$keyword = '%' .like_escape( $keyword ). '%';	
		$sqlCount = "SELECT COUNT(ID) as count FROM {$this->domainstable} where domain LIKE %s";
		$totaldata = $wpdb->get_col($wpdb->prepare($sqlCount, $keyword));

		if($totaldata){
			 
			$pagenum = $totaldata[0]; 
		}
		
		$offset = ($currentpage - 1) * $rowsperpage;	
		$sql = "SELECT  domain as col1, fol_strip as col2, ID as col3 FROM {$this->domainstable}  
		where domain LIKE %s ORDER BY {$orderby} {$order} LIMIT %d, %d";
	
		$results = $wpdb->get_results($wpdb->prepare($sql,$keyword, $offset, $rowsperpage), ARRAY_A);
	   
		$count = sizeof($results);		
	
		return array($results,$count, $pagenum);
	
	
	}
	
	function check_domain($domain_chk){
		global $wpdb;
		$responce = array(0,false,0);
		$keyword = '%' .like_escape( $domain_chk ). '%';
		if($domain_chk){
			$sql = "SELECT ID, domain, fol_strip FROM {$this->domainstable} WHERE domain LIKE %s LIMIT 1";
			$results = $wpdb->get_results($wpdb->prepare($sql, $keyword), ARRAY_A);
			//print_r($results);
		//	die;
			if($results){
			
					$responce = array(1,$results[0]["fol_strip"],$results[0]["ID"]);
				
			}
				
		}
		
		return $responce;

	}
	
	function ajax_domain_update() {
	//	$myFile = LINKPATROL_PLUGIN_DIR."/dumpfile.txt";
		//$fh = fopen($myFile, 'w') or die("can't open file");
		//print_r ( $_POST ["domainlist"] );
		//$stringData = $value ['domain']." - ".$resp[0]." - ".$resp[2]."\n";
		//	fwrite($fh, $stringData);
	
		if ( !current_user_can( $this->capability_domain ) )
			die( json_encode( array( 'success' => "Don't have Permission") ) );
		
		check_ajax_referer("reports_ajax",  "nonce" );
		/*if(!wp_verify_nonce(  $_POST ["nonce"], "reports_ajax" ))
			die( json_encode( array( 'success' => wp_create_nonce('reports_ajax')) ) );*/
		
		if(!empty($_POST ["updatelist"])){
		foreach ( $_POST ["updatelist"] as $value ) {
			$domain = preg_replace("/[\r\n]+/", "\n", $value['domain']);
			$domain = preg_replace("/\s+/", ' ', $domain);
			$domain = trim($domain);
			$resp = $this->check_domain ( $domain);
			if(!empty($value ['delete']) && $resp[0]){
				
					$this->delete_item($resp[2]);
				
			}else{
				if(empty($value ['delete'])){
					if ($resp[0]) {
						$this->update_item(array($domain, $value ['state']), $resp[2]);
					}
					else {
						$this->add_new_item (array($domain, $value ['state']));
					}
				}
				
			}
			
			
			
			
		}		
		}
		
		die( json_encode( array( 'success' => 'Update was successful') ) );
	}
	

}