jQuery(document).ready(function($){
	var i;	
	var lp_total = totalposts;
	var lp_count = 0;
	var lp_percent = 0;
	var lp_successes = 0;
	var lp_errors = 0;
	var lp_failedlist = '';
	var lp_resulttext = '';
	var lp_timestart = new Date().getTime();
	var lp_timeend = 0;
	var lp_totaltime = 0;
	var lp_continue = true;
	var chunk= 1000;

	// Create the progress bar
	$("#linkpatrol-bar").progressbar();
	$("#linkpatrol-bar-progress").html( "0%" );
	
	// Clear out the empty list element that's there for HTML validation purposes
	$("#linkpatrol-debuglist li").remove();

	// Called after each resize. Updates the progress bar.
	function LinkPatrolLinksUpdateStatus( lp_count, success, response ) {
		$("#linkpatrol-bar").progressbar( "value", ( lp_count / lp_total ) * 100 );
		$("#linkpatrol-bar-progress").html( Math.round( ( lp_count / lp_total ) * 1000 ) / 10 + "%" );
	}

	// Called when posts have been processed. Shows the results and cleans up.
	function LinkPatrolLinksFinishUp() {
		lp_timeend = new Date().getTime();
		lp_totaltime = Math.round( ( lp_timeend - lp_timestart ) / 1000 );
		$('#linkpatrol-stop').hide();
		$("#scanbutton").removeAttr("disabled");
		lp_resulttext = 'Scan was successful. Time ' + lp_totaltime + ' seconds';
		$('#message').html('<p><strong>' + lp_resulttext + '</strong></p>');
		$('#message').show();
	}

	// LinkPatrolerate a specified image via AJAX
	function LinkPatrolLink( lp_count, chunk ) {
		
		$.ajax({
			type: 'POST',
			url: ajaxurl,
			data: { action: 'linkpatrolscanner', offset:lp_count, limit:chunk },
			success: function( response ) {
				
				if ( response !== Object( response ) || ( typeof response.success === 'undefined' && typeof response.error === 'undefined' ) ) {
					response = new Object;
					response.success = false;				
				}
				if ( response.success ) {				
					LinkPatrolLinksUpdateStatus( lp_count, true, response );
				} else {					
					LinkPatrolLinksUpdateStatus( lp_count, false, response );
				}
				if ( lp_count<lp_total  && lp_continue ) {
					if((lp_total-lp_count)<chunk)
					chunk = (lp_total-lp_count);							
					lp_count = lp_count + chunk;
					LinkPatrolLink( lp_count, chunk);
				} else {
					LinkPatrolLinksFinishUp();
					if(lp_count>=lp_total)
					window.location = reports_pageurl;
				}
			},
			error: function( response ) {
				
				LinkPatrolLinksUpdateStatus( lp_count, false, response );

				if ( lp_count<lp_total && lp_continue ) {
					if((lp_total-lp_count)<chunk)
						chunk = (lp_total-lp_count);
						LinkPatrolLink( lp_count, chunk);
				} else {
					LinkPatrolLinksFinishUp();
					if(lp_count>=lp_total)
					window.location = reports_pageurl;
				}
			}
		});
	}
	
	$("#scanbutton").click(function(){
		lp_timestart = new Date().getTime();
		$(this).attr('disabled', true);
		LinkPatrolLink( lp_count, chunk);
	});
	
});